#include <bits/stdc++.h>
#define ll long long
#define MAXN 1000005
#define INF ((long long)(1e18))
using namespace std;

typedef struct
{
  ll x;
  ll h;
  int i;
} Jarbol;

Jarbol jarbol[MAXN];
int L[MAXN], R[MAXN];
ll res[MAXN];

ll solve(int i, int k1, int k2)
{
  ll min_d = INF;
  ll h = jarbol[i].h;
  ll x = jarbol[i].x;

  ll h1 = jarbol[k1].h, x1 = jarbol[k1].x;
  ll h2 = jarbol[k2].h, x2 = jarbol[k2].x;

  if (h > h1 && h > h2)
  {
    return INF;
  }

  ll xm = (h1 + x1 - h2 + x2) / 2;

  if (h <= h1)
  {
    ll lx = x1 + (h1 - h);
    if (k1 != i && lx >= x1 && lx <= xm)
    {
      ll d = abs(x - lx);
      if (d < min_d)
      {
        min_d = d;
      }
    }
  }

  if (h <= h2)
  {
    ll dx = x2 - (h2 - h);
    if (k2 != i && dx <= x2 && dx >= xm)
    {
      ll d = abs(x - dx);
      if (d < min_d)
      {
        min_d = d;
      }
    }
  }

  return min_d;
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  int N;
  cin >> N;

  for (int i = 0; i < N; i++)
  {
    cin >> jarbol[i].x;
    jarbol[i].i = i;
  }

  for (int i = 0; i < N; i++)
  {
    cin >> jarbol[i].h;
  }

  sort(jarbol, jarbol + N, [](Jarbol &a, Jarbol &b)
       { return a.x < b.x; });

  stack<ll> s;
  for (int i = 0; i < N; i++)
  {
    while (!s.empty() && jarbol[s.top()].h < jarbol[i].h)
    {
      s.pop();
    }

    if (s.empty())
    {
      L[i] = -1;
    }
    else
    {
      L[i] = s.top();
    }

    s.push(i);
  }

  s = stack<ll>();
  for (int i = N - 1; i >= 0; i--)
  {
    while (!s.empty() && jarbol[s.top()].h < jarbol[i].h)
    {
      s.pop();
    }

    if (s.empty())
    {
      R[i] = -1;
    }
    else
    {
      R[i] = s.top();
    }

    s.push(i);
  }

  for (int i = 0; i < N; i++)
  {
    ll min_d = INF;
    if (L[i] != -1)
    {
      min_d = min(min_d, solve(i, L[i], L[i] + 1));
    }
    if (R[i] != -1)
    {
      min_d = min(min_d, solve(i, R[i] - 1, R[i]));
    }

    res[jarbol[i].i] = (min_d == INF) ? -1 : min_d;
  }

  for (int i = 0; i < N; i++)
  {
    cout << res[i] << "\n";
  }
}